from fractions import Fraction
from math import sqrt

def cross(a, b):
    return a[0] * b[1] - a[1] * b[0]
    
def sub(a, b):
    return (a[0] - b[0], a[1] - b[1])

def add(a, b):
    return (a[0] + b[0], a[1] + b[1])
    
def mul(a, k):
    return (a[0] * k, a[1] * k)
    
def dot(a, b):
    return a[0] * b[0] + a[1] * b[1]
    
def norm(x, y):
    l = sqrt(x * x + y * y)
    return (x / l, y / l)

class Value:
    
    def __init__(self, x, y):
        if type(x) is Value:
            if x.t == 0 and y.t == 0:
                self.x = x.x
                self.y = y.x
                self.t = 1
            elif x.t == 1 and y.t == 1:
                a, b, c, d = x.x, x.y, y.x, y.y
                self.x = add(x.x, mul(sub(b, a), cross(sub(d, a), sub(c, a)) / cross(sub(d, c), sub(b, a))))
                self.y = None
                self.t = 0
            else:
                if x.t == 0:
                    x, y = y, x

                n = sub(x.x, x.y)
                n = norm(-n[1], n[0])
                n = mul(n, -2 * dot(sub(y.x, x.x), n)) # or -1???
                self.x = add(y.x, n)
                self.y = None
                self.t = 0
        else:
            self.x = (x, y)
            self.y = None
            self.t = 0
            
    def __str__(self):
        if self.t == 0:
            return str(self.x[0]) + " " + str(self.x[1])
        else:
            return "line " + str(self.x) + " " + str(self.y)

def calc(expr):
    #print(expr)
    n = len(expr)
    bal = 0
    maxbal = 0
    for i in range(n - 1, -1, -1):
        if expr[i] == '(':
            bal -= 1
        if expr[i] == ')':
            bal += 1
        maxbal = max(maxbal, bal)
        if bal == 0 and expr[i] == '@':
            return Value(calc(expr[:i]), calc(expr[i + 1:]))
    if expr[0] == '(' and maxbal == 1:
        a = expr[1:n-1].split(',')
        return Value(int(a[0]), int(a[1]))
    return calc(expr[1:n-1])

f = open('input.txt')
while True:
    data = f.readline().strip()
    if data == '#':
        break
    print(calc(data))
